% Copyright (c) 2013, Massachusetts Institute of Technology
% This program was presented in the book "Visual Psychophysics:
% From Laboratory to Theory" by Zhong-Lin Lu and Barbara Dosher.
% The book is available at http://mitpress.mit.edu/books/visual-psychophysics

%%% Program costfunc.m
function L = costfunc(guess, data)

zHits_observed =data(1,:);
zFA_observed = data(2, :);
d = guess(1);
sigma = guess(2);
criteria = guess(3:7);

zHits_predicted = norminv(1-normcdf(criteria, d, sigma));
zFA_predicted  = norminv(1- normcdf(criteria, 0, 1));
L = sum((zHits_observed - zHits_predicted).^2 + ...
    (zFA_observed - zFA_predicted).^2);


